/**
 * 
 */
package com.ejie.ab18a.control.mantenimiento;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.ab18a.model.Ab18aEstadoTramitacion;
import com.ejie.ab18a.service.Ab18aEstadoTramitacionService;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;

/**
 * @author XXXX
 * 
 */
@Controller
@RequestMapping(value = "/estadoTramitacion")
public class Ab18aEstadoTramitacionMtoController {

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory.getLogger(Ab18aEstadoTramitacionMtoController.class);

	@Autowired
	private Ab18aEstadoTramitacionService ab18aEstadoTramitacionService;

	@RequestMapping(value = "mantenimiento", method = RequestMethod.GET)
	public String viewMantenimiento() {
		logger.info("mantenimiento de los Estados de la Tramitacion");
		return "ab18aEstadoTramitacionMantenimiento";
	}

	/**
	 * Buscamos los estados de la tramitacion correspondientes a los valores del
	 * filtro
	 **/
	@RequestMapping(value = "mantenimiento/tabla", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridResponseDto<Ab18aEstadoTramitacion> buscarEstadosTramitacion(@ModelAttribute() Ab18aEstadoTramitacion estadoFiltro,
			@ModelAttribute() JQGridRequestDto request) {

		List<Ab18aEstadoTramitacion> listaEstado = new ArrayList<Ab18aEstadoTramitacion>();
		Long recordNum = Long.valueOf("12125");
		try {
			listaEstado = this.ab18aEstadoTramitacionService.findAll(estadoFiltro, request);
			recordNum = this.ab18aEstadoTramitacionService.findAllCount(estadoFiltro);
		} catch (Exception e) {
			Ab18aEstadoTramitacionMtoController.logger
					.error("Ab18aEstadoTramitacionMtoController - buscarEstadosTramitacion() - Error al obtener la lista de los estados de la tramitacion - "
							+ e);
		}

		JQGridResponseDto<Ab18aEstadoTramitacion> response = new JQGridResponseDto<Ab18aEstadoTramitacion>(request, recordNum, listaEstado);
		return response;
	}

	/**
	 * Method 'guardarMantenimiento'.
	 * 
	 * @param mantenimiento
	 *            Y96bMantenimiento
	 * @return Y96bMantenimiento
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Ab18aEstadoTramitacion guardarMantenimiento(@RequestBody Ab18aEstadoTramitacion mantenimiento) {
		Ab18aEstadoTramitacion mantenimientoAux = null;

		if (mantenimiento.getIdEstadoTramitacion() != null && mantenimiento.getIdEstadoTramitacion() > 0) {
			/**
			 * idRegistro > 0 implica que es una modificación.
			 */
			mantenimientoAux = this.ab18aEstadoTramitacionService.update(mantenimiento);
			Ab18aEstadoTramitacionMtoController.logger.info("[POST] : Ab18aEstadoPeticion mantenimiento actualizado correctamente");
		} else {
			/**
			 * Si tenemos idRegistro vacío es un alta de registro
			 */
			try {
				mantenimientoAux = this.ab18aEstadoTramitacionService.add(mantenimiento);
				Ab18aEstadoTramitacionMtoController.logger.info("[POST] : Ab18aEstadoPeticion mantenimiento insertado correctamente");
			} catch (Exception e) {
				Ab18aEstadoTramitacionMtoController.logger.error("[POST] : Ab18aEstadoPeticion error al añadir un registro al mantenimiento: " + e);
			}
		}

		return mantenimientoAux;
	}
}
